<?php

namespace App\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;


class Json implements CastsAttributes
{
    /**
     * Cast the given value.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array  $attributes
     * @return mixed
     */
    public function get($model, string $key, $value, array $attributes)
    {
        if (isset($value) == false) {
            return;
        }

        return  json_decode($value, true);
    }

    /**
     * Prepare the given value for storage.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array  $attributes
     * @return mixed
     */
    public function set($model, string $key, $value, array $attributes)
    {
        if (isset($value) == false) {
            return;
        }

        if (is_array($value) || is_object($value)) {

            return json_encode($value);
        }

        return $value;
    }
}
