<?php

namespace App\Http\Middleware;

use Closure;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

class JwtPrivateFile
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        try {
            $token = $request->query('token') ?: $request->bearerToken();

            if (!$token) {
                throw new Exception('Unauthorized');
            }

            $user = JWTAuth::setToken($token)->toUser();

            if (!$user) {
                throw new Exception('Unauthorized');
            }

            $request->attributes->set('authenticated_user', $user);

            return $next($request);
        } catch (Throwable $e) {
        }

        abort(401);
    }
}
