<?php

namespace App\Http\Requests\AcademicLevel;

use App\Enums\PermissionAcademicLevelAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class UpdateAcademicLevelRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionAcademicLevelAccess::update];

    public function rules()
    {

        return [
            'id' => [
                'required',
                'numeric',
                'exists:academic_levels,id',
            ],
            'academic_level.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
        ];
    }
}
