<?php

namespace App\Http\Requests\ApplicationConfig;

use App\Enums\PermissionApplicationConfigAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class UpdateApplicationConfigSchoolInformationRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionApplicationConfigAccess::update];

    public function rules()
    {
        return [
            'school.title' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabetic
            ],
            'school.province' => [
                'required',
                'string',
                'min:3',
                'max:30',
                'regex:' . Regex::alphabetic
            ],
            'school.district' => [
                'required',
                'string',
                'min:2',
                'max:30',
                'regex:' . Regex::alphabetic
            ],
            'school.code' => [
                'required',
                'string',
                'min:2',
                'max:30',
                'regex:' . Regex::alphabetic
            ],
            'school.type' => [
                'required',
                'string',
                'min:2',
                'max:30',
                'regex:' . Regex::alphabetic
            ],
            'school.image' => [
                'mimes:png',
                'max:1024'
            ],
        ];
    }
}
