<?php

namespace App\Http\Requests\ApplicationConfig;

use App\Enums\PermissionApplicationConfigAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class UpdateApplicationConfigTermRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionApplicationConfigAccess::termUpdate];

    public function rules()
    {
        return [
            'terms' => ['required', 'array', 'min:1', 'max:10'],
            'terms.*.term' => [
                'required',
                'numeric',
                'min:1',
                'max:10',
                'distinct',
            ],
            'terms.*.title' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabetic
            ],
            'terms.*.started_at' => [
                'required',
                'string',
                'regex:' . Regex::persianDateMD,
            ],
            'terms.*.ended_at' => [
                'required',
                'string',
                'regex:' . Regex::persianDateMD,
            ],
        ];
    }
}
