<?php

namespace App\Http\Requests\Auth;

use App\Http\Requests\Model\ModelBaseRequest;
use App\Rules\NationalCode;
use App\Tools\Regex;

class ForgetAuthRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [];

    public function rules()
    {
        return [
            'name' => ['required', 'string', 'max:30', 'regex:' . Regex::usernameWithPhoneNumber],
            'national_code' => ['required', 'string', 'max:10', new NationalCode()],
        ];
    }
}
