<?php

namespace App\Http\Requests\Auth;

use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class SignInAuthRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [];

    public function rules()
    {
        return [
            'name' => ['required', 'string', 'min:2', 'max:30', 'regex:' . Regex::usernameWithNumber],
            'password' => ['required', 'string', 'max:30'],
            'app' => ['boolean'],
        ];
    }
}
