<?php

namespace App\Http\Requests\Bell;

use App\Enums\PermissionBellAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class StoreBellRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionBellAccess::store];

    public function rules()
    {
        return [
            'bell.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            'bell.started_at' => [
                'required',
                'date_format:H:i:s',
            ],
            'bell.ended_at' => [
                'required',
                'date_format:H:i:s',
                'after:bell.started_at',
            ],
        ];
    }
}
