<?php

namespace App\Http\Requests\ClassRoom;

use App\Enums\PermissionClassRoomAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class UpdateClassRoomRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionClassRoomAccess::update];

    public function rules()
    {
        $id = -1;

        try {
            $id = $this->request->get('id', -1);
        } catch (\Throwable $th) {
            //ignore
        }

        return [
            'id' => [
                'required',
                'numeric',
                'exists:class_rooms,id',
            ],

            'class_room.major_id' => [
                'required',
                'numeric',
                'exists:majors,id'
            ],
            'class_room.academic_level_id' => [
                'required',
                'numeric',
                'exists:academic_levels,id'
            ],
            'class_room.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            'class_room.code' => [
                'required',
                'string',
                'min:1',
                'max:255',
                'regex:' . Regex::alphabetic,
                "unique:class_rooms,code,$id",
            ],
        ];
    }
}
