<?php

namespace App\Http\Requests\DailyReport;

use App\Enums\PermissionDailyReportAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExportPdfDailyReportRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionDailyReportAccess::exportPDF,
    ];

    public function rules()
    {
        return [
            'date' => ['date_format:Y-m-d']
        ];
    }
}
