<?php

namespace App\Http\Requests\Lesson;

use App\Enums\PermissionLessonAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteLessonRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionLessonAccess::delete];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:lessons,id'],
        ];
    }
}
