<?php

namespace App\Http\Requests\Lesson;

use App\Enums\PermissionLessonAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class UpdateLessonRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionLessonAccess::update];

    public function rules()
    {

        return [
            'id' => [
                'required',
                'numeric',
                'exists:lessons,id',
            ],
            'lesson.class_room_id' => [
                'required',
                'numeric',
                'exists:class_rooms,id'
            ],
            'lesson.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            'lesson.passing_grade' => [
                'required',
                'numeric',
                'min:0',
                'max:20'
            ],
            'lesson.is_podmany' => [
                'required',
                'boolean',
            ],
        ];
    }
}
