<?php

namespace App\Http\Requests\Major;

use App\Enums\PermissionMajorAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class StoreMajorRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionMajorAccess::store];

    public function rules()
    {
        return [
            'major.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
        ];
    }
}
