<?php

namespace App\Http\Requests\Major;

use App\Enums\PermissionMajorAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class UpdateMajorRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionMajorAccess::update];

    public function rules()
    {

        return [
            'id' => [
                'required',
                'numeric',
                'exists:majors,id',
            ],
            'major.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
        ];
    }
}
