<?php

namespace App\Http\Requests\Moral;

use App\Enums\PermissionMoralAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteMoralRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionMoralAccess::delete,
        PermissionMoralAccess::teacherDelete
    ];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:morals,id'],
        ];
    }
}
