<?php

namespace App\Http\Requests\Moral;

use App\Enums\PermissionMoralAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Models\User;
use App\Rules\OwnStudentWithSchoolSessionRule;
use App\Rules\SchoolSessionAccessRule;
use App\Tools\Regex;
use Throwable;

class StoreMoralRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionMoralAccess::store,
        PermissionMoralAccess::teacherStore
    ];

    public function rules()
    {
        $isNotAdmin = true;

        try {
            $isNotAdmin = !User::findOrFail(
                auth()->user()
                    ->id
            )
                ->hasPermissions(PermissionMoralAccess::store);
        } catch (Throwable $th) {
        }

        return [
            'morals' => ['required', 'array', 'min:1', 'max:100'],
            'morals.*.school_session_id' => [
                'required',
                'numeric',
                'exists:school_sessions,id',
                ...($isNotAdmin ? [new SchoolSessionAccessRule()] : [])
            ],
            'morals.*.student_id' => [
                'required',
                'numeric',
                'exists:students,id',
                new OwnStudentWithSchoolSessionRule('student_id', 'morals.*.school_session_id')
            ],
            'morals.*.comment' => [
                'string',
                'min:3',
                'max:700',
                'regex:' . Regex::alphabetic
            ],
            'morals.*.moral' => [
                'required',
                'numeric',
                'min:0',
                'max:5',
            ],
        ];
    }
}
