<?php

namespace App\Http\Requests\Presence;

use App\Enums\PermissionPresenceAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeletePresenceRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionPresenceAccess::delete,
        PermissionPresenceAccess::selfDelete
    ];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:presences,id'],
        ];
    }
}
