<?php

namespace App\Http\Requests\Role;

use App\Enums\PermissionRoleAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\Regex;

class StoreRoleRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionRoleAccess::store];


    public function rules()
    {
        return [
            'role.name' => ['required', 'string', 'min:3', 'max:60', 'regex:' . Regex::english],
            'role.title' => ['required', 'string', 'min:3', 'max:120', 'regex:' . Regex::alphabeticPersian],
            'role.permissions' => ['required', 'array', 'min:1'],
            'role.permissions.*' => ['required', 'numeric', 'exists:permissions,id'],
        ];
    }
}
