<?php

namespace App\Http\Requests\SchoolSession;

use App\Enums\PermissionSchoolSessionAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Models\User;
use App\Tools\Regex;

class StoreSchoolSessionRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionSchoolSessionAccess::store,
        PermissionSchoolSessionAccess::selfStore
    ];

    public function rules()
    {
        $isAdmin = false;
        try {
            $isAdmin = User::findOrFail(
                auth()
                    ->user()
                    ->id
            )
                ->hasPermissions(PermissionSchoolSessionAccess::store);
            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }

        return [
            ...($isAdmin ? [
                'school_session.teacher_user_id' => [
                    'required',
                    'numeric',
                    'exists:users,id'
                ],
                'school_session.held' => [
                    'required',
                    'bool'
                ]
            ] : []),

            'school_session.comment' => [
                'string',
                'min:3',
                'max:700',
                'regex:' . Regex::alphabetic
            ],
            'school_session.activity' => [
                'string',
                'min:3',
                'max:700',
                'regex:' . Regex::alphabetic
            ],
            'school_session.started_at' => [
                'date_format:Y-m-d H:i',
            ],
        ];
    }
}
