<?php

namespace App\Http\Requests\SchoolSession;

use App\Enums\PermissionSchoolSessionAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Models\User;
use App\Tools\Regex;

class UpdateSchoolSessionRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionSchoolSessionAccess::update,
        PermissionSchoolSessionAccess::selfUpdate
    ];

    public function rules()
    {

        $isAdmin = false;
        try {
            $isAdmin = User::findOrFail(
                auth()
                    ->user()
                    ->id
            )
                ->hasPermissions(PermissionSchoolSessionAccess::update);
            //code...
        } catch (\Throwable $th) {
            //throw $th;
        }

        return [
            'id' => [
                'required',
                'numeric',
                'exists:school_sessions,id',
            ],

            ...($isAdmin ? [
                'school_session.teacher_user_id' => [
                    'required',
                    'numeric',
                    'exists:users,id'
                ],
                'school_session.held' => [
                    'required',
                    'bool'
                ]
            ] : []),

            'school_session.comment' => [
                'string',
                'min:3',
                'max:700',
                'regex:' . Regex::alphabetic
            ],
            'school_session.activity' => [
                'string',
                'min:3',
                'max:700',
                'regex:' . Regex::alphabetic
            ],
        ];
    }
}
