<?php

namespace App\Http\Requests\Student;

use App\Enums\PermissionStudentAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteStudentRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionStudentAccess::delete];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:students,id'],
        ];
    }
}
