<?php

namespace App\Http\Requests\Teacher;

use App\Enums\PermissionTeacherAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Rules\NationalCodeRule;
use App\Tools\Regex;

class StoreTeacherRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionTeacherAccess::store];


    public function rules()
    {
        return [
            'teacher.personally_code' => [
                'required',
                'string',
                'min:6',
                'max:120',
                'unique_encrypted:teachers,personally_code'
            ],
            'teacher.user.name' => [
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::username,
                'unique_encrypted:users,name'
            ],
            'teacher.user.active' => [
                'in:0,1,2'
            ],
            'teacher.user.role_id' => [
                'int',
                'exists:roles,id',
                'gt:1'
            ],
            'teacher.user.password' => [
                'confirmed',
                'min:6'
            ],
            'teacher.user.profile' => [
                'required'
            ],
            'teacher.user.profile.first_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'teacher.user.profile.last_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'teacher.user.profile.national_code' => [
                'required',
                'string',
                'max:10',
                new NationalCodeRule(),
                'unique_encrypted:profiles,national_code'
            ],
            'teacher.user.profile.address' => [
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            'teacher.user.profile.phone' => [
                'required',
                'string',
                'min:3',
                'max:12',
                'regex:' . Regex::englishNumber,
                'unique_encrypted:profiles,phone'
            ],
            'teacher.user.profile.image' => [
                'mimes:jpeg,jpg,png,webp,avif',
                'max:1024'
            ],
        ];
    }
}
