<?php

namespace App\Http\Requests\TeachingReport;

use App\Enums\PermissionTeachingReportAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class DeleteTeachingReportRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionTeachingReportAccess::delete,
        PermissionTeachingReportAccess::teacherDelete
    ];

    public function rules()
    {
        return [
            'id' => ['required', 'numeric', 'exists:teaching_reports,id'],
        ];
    }
}
