<?php

namespace App\Http\Requests\TeachingReport;

use App\Enums\PermissionTeachingReportAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExportPDFTeachingReportRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionTeachingReportAccess::exportPDF
    ];

    public function rules()
    {
        return [
            'year' => ['numeric', 'min:1350', 'max:2000'],
            'term' => ['numeric', 'min:1', 'max:3']
        ];
    }
}
