<?php

namespace App\Http\Requests\TeachingReport;

use App\Enums\PermissionTeachingReportAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Rules\CheckPodmanyTeachingReportRule;
use App\Rules\OwnStudentWithLessonRule;

class UpdateTeachingReportRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionTeachingReportAccess::update,
        PermissionTeachingReportAccess::teacherUpdate,
    ];

    public function rules()
    {

        return [
            'teaching_reports' => [
                'required',
                'array',
                'min:1',
                'max:100'
            ],
            'teaching_reports.*' => [

                new CheckPodmanyTeachingReportRule(),
            ],
            'teaching_reports.*.id' => [
                'required',
                'numeric',
                'exists:teaching_reports,id',
            ],
            'teaching_reports.*.lesson_id' => ['required', 'numeric', 'exists:lessons,id'],
            'teaching_reports.*.student_id' => [
                'required',
                'numeric',
                'exists:students,id',
                new OwnStudentWithLessonRule('student_id', 'teaching_reports.*.lesson_id')
            ],
            'teaching_reports.*.final_grade' => [
                'required_without_all:teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',

                'missing_with:teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',
                'min:0',
                'max:20',
                'decimal:0,20',
            ],

            'teaching_reports.*.term' => [
                'required',
                'numeric',
                'min:0',
                'max:5',
            ],

            'teaching_reports.*.genesis_grade' => [
                'required_without_all:teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',

                'missing_with:teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',

                'min:0',
                'max:20',
                'decimal:0,20',
            ],

            'teaching_reports.*.podmany_one_grade' => [
                'required_without_all:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',

                'missing_with:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',

                'numeric',
                'min:0',
                'max:20',
                'decimal:0,20',
            ],
            'teaching_reports.*.podmany_two_grade' => [
                'required_without_all:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',

                'missing_with:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_three_grade,teaching_reports.*.podmany_four_grade,teaching_reports.*.podmany_five_grade',

                'numeric',
                'min:0',
                'max:20',
                'decimal:0,20',
            ],
            'teaching_reports.*.podmany_three_grade' => [
                'required_without_all:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade',

                'missing_with:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade',

                'numeric',
                'min:0',
                'max:20',
                'decimal:0,20',
            ],
            'teaching_reports.*.podmany_four_grade' => [
                'required_without_all:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade',

                'missing_with:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade',

                'numeric',
                'min:0',
                'max:20',
                'decimal:0,20',
            ],
            'teaching_reports.*.podmany_five_grade' => [
                'required_without_all:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade',

                'missing_with:teaching_reports.*.final_grade,teaching_reports.*.genesis_grade,teaching_reports.*.podmany_one_grade,teaching_reports.*.podmany_two_grade',

                'numeric',
                'min:0',
                'max:20',
                'decimal:0,20',
            ],
        ];
    }
}
