<?php

namespace App\Http\Requests\User;

use App\Enums\PermissionUserAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Rules\NationalCodeRule;
use App\Tools\Regex;

class StoreUserRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionUserAccess::store];


    public function rules()
    {
        return [
            'user.name' => [
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::username,
                'unique_encrypted:users,name'
            ],
            'user.active' => [
                'in:0,1,2'
            ],
            'user.role_id' => [
                'int',
                'exists:roles,id',
                'gt:1'
            ],
            'user.password' => [
                'confirmed',
                'min:6'
            ],
            'user.profile' => [
                'required'
            ],
            'user.profile.first_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'user.profile.last_name' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:' . Regex::alphabeticPersian
            ],
            'user.profile.address' => [
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            'user.profile.national_code' => [
                'required',
                'string',
                'max:10',
                new NationalCodeRule(),
                'unique_encrypted:profiles,national_code'
            ],
            'user.profile.phone' => [
                'required',
                'string',
                'min:3',
                'max:12',
                'regex:' . Regex::englishNumber,
                'unique_encrypted:profiles,phone'
            ],
            'user.profile.image' => [
                'mimes:jpeg,jpg,png,webp,avif',
                'max:1024'
            ],
        ];
    }
}
