<?php

namespace App\Http\Requests\User;

use App\Enums\PermissionUserAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class UpdateUserStatusRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionUserAccess::statusEdit];
    public function rules()
    {
        return [
            'id' => ['required', 'int', 'gt:1', 'exists:users,id'],
            'user.active' => ['required', 'in:0,1,2']
        ];
    }
}
