<?php

namespace App\Http\Requests\WeeklySchedule;

use App\Enums\PermissionWeeklyScheduleAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExcelStoreWeeklyScheduleRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionWeeklyScheduleAccess::store];


    public function rules()
    {
        return [
            'xlsx' => ['required', 'mimes:xlsx', 'max:10240'],
        ];
    }
}
