<?php

namespace App\Http\Requests\WeeklySchedule;

use App\Enums\PermissionWeeklyScheduleAccess;
use App\Http\Requests\Model\ModelBaseRequest;

class ExportPDFWeeklyScheduleRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [
        PermissionWeeklyScheduleAccess::exportPDF,
        PermissionWeeklyScheduleAccess::teacherExportPDF,
    ];

    public function rules()
    {
        return [
            'year' => ['numeric', 'min:1350', 'max:2000']
        ];
    }
}
