<?php

namespace App\Http\Requests\WeeklySchedule;

use App\Enums\BellType;
use App\Enums\PermissionWeeklyScheduleAccess;
use App\Http\Requests\Model\ModelBaseRequest;
use App\Tools\CommonTools;
use App\Tools\Regex;

class UpdateWeeklyScheduleRequest extends ModelBaseRequest
{
    protected $authorizePermissions = [PermissionWeeklyScheduleAccess::update];

    public function rules()
    {

        return [
            'id' => [
                'required',
                'numeric',
                'exists:weekly_schedules,id',
            ],
            'weekly_schedule.bell_id' => [
                'required',
                'numeric',
                'exists:bells,id',
            ],
            'weekly_schedule.class_room_id' => [
                'required',
                'numeric',
                'exists:class_rooms,id',
            ],
            'weekly_schedule.lesson_id' => [
                'required',
                'numeric',
                'exists:lessons,id',
            ],
            'weekly_schedule.teacher_id' => [
                'required',
                'numeric',
                'exists:users,id',
            ],
            'weekly_schedule.day' => [
                'required',
                'numeric',
                'min:0',
                'max:6',
            ],
            'weekly_schedule.bell_type' => [
                'required',
                'in:' . CommonTools::enumToString(BellType::class),
            ],
        ];
    }
}
