<?php

namespace App\Imports;

use App\Exceptions\AnyException;
use App\Models\ClassRoom;
use App\Tools\Regex;
use Arr;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\PersistRelations;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithValidation;

class LessonImport implements ToCollection, WithValidation, WithHeadingRow, WithMapping, PersistRelations
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $collection)
    {

        foreach ($collection as $row) {
            $lessonAdd = $row['lesson'];
            $classRoom = ClassRoom::where(
                'code',
                '=',
                $lessonAdd['class_code']
            )
                ->firstOrFail();

            $classRoom->lessons()
                ->create(
                    Arr::only($lessonAdd, [
                        'title',
                        'passing_grade',
                        'is_podmany',
                    ])
                );
        }
    }


    public function map($row): array
    {
        try {
            $isPodmany = strval($row['is_podmany']);
            $isPodmany = $isPodmany === '1' || $isPodmany === 'true';

            return [
                'lesson' => [
                    'class_code' => $this->valueOrNull(strval($row['class_code'])),
                    'title' => strval($row['title']),
                    'passing_grade' => strval($row['passing_grade']),
                    'is_podmany' =>  $isPodmany,
                ]
            ];
        } catch (\Throwable $th) {
            //throw $th;
        }

        throw new AnyException(__('messages.error_excel_parse_row'));
    }


    public function rules(): array
    {

        return [
            '*.lesson.class_code' => [
                'required',
                'string',
                'min:1',
                'max:100',
                'exists:class_rooms,code'
            ],
            '*.lesson.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
            '*.lesson.passing_grade' => [
                'required',
                'numeric',
                'min:0',
                'max:20'
            ],
            '*.lesson.is_podmany' => [
                'required',
                'boolean',
            ],
        ];
    }

    private function valueOrNull($value)
    {
        return strlen(strval($value)) > 0 ? $value : null;
    }
}
