<?php

namespace App\Imports;

use App\Exceptions\AnyException;
use App\Models\Major;
use App\Tools\Regex;
use Arr;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\PersistRelations;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithValidation;

class MajorImport implements ToCollection, WithValidation, WithHeadingRow, WithMapping, PersistRelations
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $collection)
    {

        foreach ($collection as $row) {
            Major::create($row['major']);
        }
    }


    public function map($row): array
    {
        try {
            return Arr::undot([
                'major.title' => strval($row['title']),
            ]);
        } catch (\Throwable $th) {
            //throw $th;
        }

        throw new AnyException(__('messages.error_excel_parse_row'));
    }


    public function rules(): array
    {

        return [
            '*.major.title' => [
                'required',
                'string',
                'min:3',
                'max:255',
                'regex:' . Regex::alphabetic
            ],
        ];
    }
}
