<?php

namespace App\Models;

use App\Casts\Json;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Log extends BaseModel
{
    use HasFactory;

    public $timestamps = true;

    protected $fillable = [
        'extra',
        'name',
        'user_id',
    ];

    protected $casts = [
        'extra' => Json::class,
        'user_id' => 'int'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
