<?php

namespace App\Models;

use ESolution\DBEncryption\Traits\EncryptedAttribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Presence extends BaseModel
{
    use HasFactory, EncryptedAttribute, HasRelationships;

    public $timestamps = true;

    protected $encryptable = [
        'delay_reason',
        'early_exit_reason',
    ];

    protected $fillable = [
        'delay_reason',
        'early_exit_reason',
        'entry_time',
        'exit_time',
        'school_session_id',
        'sms_sended_at',
        'status',
        'student_id',
    ];

    protected $casts = [
        'student_id' => 'int',
        'school_session_id' => 'int',
        'status' => 'boolean',
    ];

    protected $dates = [
        'entry_time',
        'exit_time',
        'sms_sended_at',
    ];


    public function schoolSession()
    {
        return $this->belongsTo(SchoolSession::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function classRoom()
    {
        return $this->hasOneDeep(
            ClassRoom::class,
            [SchoolSession::class, WeeklySchedule::class],
            ['id', 'id', 'id'],
            ['school_session_id', 'weekly_schedule_id', 'class_room_id']
        );
    }

    public function lesson()
    {
        return $this->hasOneDeep(
            Lesson::class,
            [SchoolSession::class, WeeklySchedule::class],
            ['id', 'id', 'id'],
            ['school_session_id', 'weekly_schedule_id', 'lesson_id']
        );
    }

    public function bell()
    {
        return $this->hasOneDeep(
            Bell::class,
            [SchoolSession::class, WeeklySchedule::class],
            ['id', 'id', 'id'],
            ['school_session_id', 'weekly_schedule_id', 'bell_id']
        );
    }
}
