<?php

namespace App\Models;

use ESolution\DBEncryption\Traits\EncryptedAttribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Profile extends BaseModel
{
    use HasFactory, EncryptedAttribute;

    protected $encryptable = [
        'address',
        'first_name',
        'last_name',
        'national_code',
        'phone',
    ];
    protected $fillable = [
        'address',
        'first_name',
        'last_name',
        'national_code',
        'phone',
        'user_id',
    ];

    protected $casts = [
        'user_id' => 'int',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function image()
    {
        return $this->morphOne(Image::class, 'imageable');
    }

    public function children()
    {
        return $this->hasMany(Student::class, 'parent_id', 'user_id');
    }
}
