<?php

namespace App\Models;

use ESolution\DBEncryption\Traits\EncryptedAttribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SchoolSession extends BaseModel
{
    use HasFactory, EncryptedAttribute;

    public $timestamps = true;

    protected $encryptable = [
        'activity',
        'comment',
    ];
    protected $fillable = [
        'activity',
        'comment',
        'created_at',
        'held',
        'teacher_user_id',
        'weekly_schedule_id',
    ];

    protected $casts = [
        'held' => 'boolean',
        'teacher_user_id' => 'int',
        'weekly_schedule_id' => 'int',
    ];


    public function teacher()
    {
        return $this->belongsTo(User::class, 'teacher_user_id');
    }

    public function weeklySchedule()
    {
        return $this->belongsTo(WeeklySchedule::class);
    }

    public function presences()
    {
        return $this->hasMany(Presence::class);
    }

    public function morals()
    {
        return $this->hasMany(Moral::class);
    }

    public function grades()
    {
        return $this->hasMany(Grade::class);
    }

    public function classRoom()
    {
        return $this->hasOneThrough(
            ClassRoom::class,
            WeeklySchedule::class,
            'weekly_schedules.id',
            'class_rooms.id',
            'Weekly_schedule_id',
            'class_room_id'
        );
    }

    public function lesson()
    {
        return $this->hasOneThrough(
            Lesson::class,
            WeeklySchedule::class,
            'weekly_schedules.id',
            'lessons.id',
            'Weekly_schedule_id',
            'lesson_id'
        );
    }
}
