<?php

namespace App\Models;

use ESolution\DBEncryption\Traits\EncryptedAttribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Morilog\Jalali\Jalalian;

class Student extends BaseModel
{
    use HasFactory, EncryptedAttribute;

    public $timestamps = true;

    protected $encryptable = [
        'first_name',
        'last_name',
        'national_code',
    ];

    protected $fillable = [
        'parent_id',
        'first_name',
        'last_name',
        'national_code',
    ];

    protected $casts = [
        'parent_id' => 'int',
    ];

    public function studentParent()
    {
        return $this->belongsTo(User::class, 'parent_id');
    }

    public function image()
    {
        return $this->morphOne(Image::class, 'imageable');
    }

    public function classRooms()
    {
        return $this->belongsToMany(ClassRoom::class)
            ->using(ClassRoomStudent::class)
            ->withTimestamps();
    }

    public function classRoomStudents()
    {
        return $this->hasMany(ClassRoom::class);
    }

    public function currentClassRooms()
    {
        $currentTerm = Jalalian::now()
            ->toArray();
        if ($currentTerm['month'] < 7) {
            $currentTerm['year']--;
        }

        $termDate = new Jalalian($currentTerm['year'], 7, 1);

        return $this->belongsToMany(ClassRoom::class)
            ->using(ClassRoomStudent::class)
            ->withTimestamps()
            ->wherePivotBetween('created_at', [
                $termDate->toCarbon(),
                (clone $termDate)->addYears(1)
                    ->toCarbon(),
            ]);
    }

    public function presences()
    {
        return $this->hasMany(Presence::class);
    }

    public function grades()
    {
        return $this->hasMany(Grade::class);
    }

    public function teachingReports()
    {
        return $this->hasMany(TeachingReport::class);
    }

    public function getCurrentClassRoomIdAttribute()
    {
        $classRoom = $this->currentClassRooms()
            ->orderBy('created_at', 'desc')
            ->first();

        return $classRoom->id ?? null;
    }
}
