<?php

namespace App\Models;

use ESolution\DBEncryption\Traits\EncryptedAttribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Teacher extends BaseModel
{
    use HasFactory, EncryptedAttribute;

    protected $encryptable = [
        'personally_code',
    ];
    protected $fillable = [
        'personally_code',
        'user_id',
    ];

    protected $casts = [
        'user_id' => 'int',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function schoolSessions()
    {
        return $this->hasMany(SchoolSession::class, 'teacher_user_id', 'user_id');
    }

    public function weeklySchedules()
    {
        return $this->hasMany(WeeklySchedule::class, 'teacher_id', 'user_id');
    }
}
