<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class TeachingReport extends BaseModel
{
    use HasFactory;


    const TERM_ONE_PODMANY = [
        'genesis_grade',
        'podmany_three_grade',
        'podmany_four_grade',
        'podmany_five_grade',
    ];

    const TERM_TWO_PODMANY = [
        'genesis_grade',
        'podmany_one_grade',
        'podmany_two_grade',
    ];

    const NOT_PODMANY = [
        'podmany_one_grade',
        'podmany_two_grade',
        'podmany_three_grade',
        'podmany_four_grade',
        'podmany_five_grade',
    ];

    public $timestamps = true;


    protected $fillable = [
        'final_grade',
        'genesis_grade',
        'lesson_id',
        'podmany_five_grade',
        'podmany_four_grade',
        'podmany_one_grade',
        'podmany_three_grade',
        'podmany_two_grade',
        'student_id',
        'term',
    ];

    protected $appends = [
        'class_room_id'
    ];

    protected $casts = [
        'class_room_id' => 'int',
        'final_grade' => 'float',
        'genesis_grade' => 'float',
        'lesson_id' => 'int',
        'podmany_five_grade' => 'float',
        'podmany_four_grade' => 'float',
        'podmany_one_grade' => 'float',
        'podmany_three_grade' => 'float',
        'podmany_two_grade' => 'float',
        'student_id' => 'int',
        'term' => 'int',
    ];


    public function classRoom()
    {
        return $this->hasOneThrough(
            ClassRoom::class,
            Lesson::class,
            'id',
            'id',
            'lesson_id',
            'class_room_id',
        );
    }

    public function lesson()
    {
        return $this->belongsTo(Lesson::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function getClassRoomIdAttribute()
    {
        return optional(
            $this->classRoom()
                ->first()
        )
            ->id ?? null;
    }
}
