<?php

namespace App\Rules;

use App\Models\Lesson;
use App\Models\TeachingReport;
use Arr;
use Closure;
use Illuminate\Contracts\Validation\DataAwareRule;
use Illuminate\Contracts\Validation\ValidationRule;

class CheckPodmanyTeachingReportRule implements DataAwareRule, ValidationRule
{
    private $lessons;

    /**
     * validation podmany lesson
     */
    public function __construct() {}

    /**
     * Run the validation rule.
     *
     * @param  \Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $lesson = $this->lessons->find($value['lesson_id'] ?? -1);
        $term = $value['term'] ?? 1;

        $isPodmany = ($lesson?->is_podmany ?? false) == true;

        if ($isPodmany) {
            $result = Arr::hasAny(
                $value,
                $term == 1 ?
                    TeachingReport::TERM_ONE_PODMANY : (
                        $term == 2 ?
                        TeachingReport::TERM_TWO_PODMANY :
                        TeachingReport::NOT_PODMANY
                    )
            );
        } else {
            $result = Arr::hasAny(
                $value,
                TeachingReport::NOT_PODMANY
            );
        }

        if (!$result) {
            return;
        }

        $fail('validation.check_podmany_teaching_report', null)
            ->translate([
                'attribute' => __(
                    'validation.attributes',
                )[preg_replace('/\.\d+$/', '.*', $attribute)] ?? $attribute,
                'lesson_title' => $lesson?->title ?? '-',
                'term' => $term
            ]);
    }


    public function setData(array $data)
    {
        if (!$this->lessons) {
            $lessonIds = collect(
                data_get($data, 'teaching_reports.*.lesson_id')
            )
                ->unique();

            $this->lessons = Lesson::select(['id', 'title', 'is_podmany'])
                ->whereIn('id', $lessonIds)
                ->get();
        }
    }
}
