<?php

/**
 * Created by IntelliJ IDEA.
 * User: Maysam
 * Date: 09/08/2018
 * Time: 04:33 PM
 */

namespace App\Tools;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class ModelTools
{

    static public function appendFields($data, $fields)
    {
        if ($fields !== null && $data !== null) {
            [$selfFields, $relationFields] = self::splitInlineToArray($fields);

            $data->append($selfFields);
            self::appendRelationFields($data, $relationFields);
        }
    }

    static public function appendRelationFields($data, $treeAppend)
    {
        $data = (is_array($data) || $data instanceof Collection) ?
            $data : (new Collection([$data]));

        foreach ($treeAppend as $key => $value) {
            if (count($value) == 0) {
                $data->append($key);
                continue;
            }



            $data->each(function ($col) use ($key, $value) {
                $tmp = $col->$key;

                if ($tmp != null) {
                    self::appendRelationFields($tmp, $value);
                    return;
                }

                $relations = $col->getRelations();
                self::appendRelationFields($relations[$key], $value);
            });
        }
    }


    static public function hideFields($data, $fields)
    {
        if ($fields !== null && $data !== null) {
            [$selfFields, $relationFields] = self::splitInlineToArray($fields);

            $data->makeHidden($selfFields);
            self::hideRelationFields($data, $relationFields);
        }
    }

    static public function hideRelationFields($data, $treeAppend)
    {
        $data = (is_array($data) || $data instanceof Collection) ?
            $data : (new Collection([$data]));

        foreach ($treeAppend as $key => $value) {
            if (count($value) == 0) {
                $data->makeHidden($key);
                continue;
            }



            $data->each(function ($col) use ($key, $value) {
                $tmp = $col->$key;

                if ($tmp != null) {
                    self::hideRelationFields($tmp, $value);
                    return;
                }

                $relations = $col->getRelations();
                self::hideRelationFields($relations[$key], $value);
            });
        }
    }

    static public function splitInlineToArray($fields)
    {
        [$selfFields, $relationFields] = array_reduce(is_array($fields) ? $fields : [$fields], function ($pValue, $cValue) {
            if (str_contains($cValue, '.')) {
                $pValue[1][] = $cValue;
            } else {
                $pValue[0][] = $cValue;
            }

            return $pValue;
        }, [[], []]);

        return [$selfFields, self::convertInlineToTree($relationFields)];
    }


    static public function convertInlineToTree($array)
    {
        $result = [];

        foreach ($array as $key => $value) {
            $parts = explode(".", $value);

            $node = &$result;
            foreach ($parts as $part) {
                if (! isset($node[$part])) {
                    $node[$part] = [];
                }
                $node = &$node[$part];
            }

            if (count($parts) === 1) {
                $node = $value;
            }
        }

        return $result;
    }
}
