<?php

namespace App\Tools;

class PathTransformer
{
    public static function transformPathTo(string $path, string $to): string
    {
        $segments = explode('.', $path);
        $toSegments = explode('.', $to);

        $newPath = [];

        foreach ($toSegments as $index => $toSegment) {
            $newPath[] = $toSegment === '*' ? $segments[$index] : $toSegment;
        }

        return implode('.', $newPath);
    }

    public static function removeNumberOfPath(string $path): string
    {
        $segments = explode('.', $path);

        $newPath = [];

        foreach ($segments as $index => $segment) {
            $newPath[] = is_numeric($segment) === true ? '*' : $segment;
        }

        return implode('.', $newPath);
    }
}
