<?php

namespace App\Tools;

class Regex
{
    public const alphabetic = '/^[a-zA-Z0-9۰۱۲۳۴۵۶۷۸۹\.,!?@؟،؛:آابپتثجچحخدذرزژسشصضطظعغفقکگلمنوهیئي \-_+={}:;.,!\/<>|()\r\n\t\%\$\&^*#«»آ\[\]]+$/';
    public const english = '/^[a-zA-Z0-9؛: ]+$/';
    public const englishNumber = '/^[0-9]+$/';
    public const englishNumberSpace = '/^[0-9\r\n\- ]+$/';
    public const persian = '/^[۰۱۲۳۴۵۶۷۸۹,،؛:آابپتثجچحخدذرزژسشصضطظعغفقکگلمنوهیئي ]+$/';
    public const alphabeticPersian = '/^[آابپتثجچحخدذرزژسشصضطظعغفقکگلمنوهیئي ]+$/';
    public const fileName = '/^[\w,\s-]+\.[A-Za-z]+$/';
    public const username = '/^[a-zA-Z0-9\-_\.]+$/';
    public const usernamePhoneNumber = '/^09[0-9]{9}$/';
    public const usernameWithPhoneNumber = '/^([a-zA-Z][a-zA-Z0-9\-_\.]+|09[0-9]{9})$/';
    public const usernameWithNumber = '/^([a-zA-Z][a-zA-Z0-9\-_\.]+|[0-9]{2,12})$/';
    public const color = '/^#[a-zA-Z0-9]{3,8}$/';
    public const accountNumber = '/^(IR|ir)[0-9]{24}$/';
    public const birthDateYMD = '/^[1-9]{1}[0-9]{3}\/(0[1-9]{1}|1[0-2]{1})\/(0[1-9]{1}|(1|2)[0-9]{1}|3[0-1]{1})$/';
    public const halfSpace = '/[\x{200C}\x{200D}\x{00A0}\x{202F}\x{2060}\x{200B}]+/u';
    public const dir = '/^[a-zA-Z0-9]+$/';
    public const persianDateMD = '/^((0[1-6]-((3[0-1])|([1-2][0-9])|(0[1-9])))|((1[0-2]|(0[7-9]))-(30|([1-2][0-9])|(0[1-9]))))$/';
}
