<?php


namespace App\Tools;


use Illuminate\Support\Facades\Log;

class ResponseTools
{
    public const RES_SUCCESS = 'success';
    public const RES_WARNING = 'warning';
    public const RES_ERROR = 'error';

    protected $response = [];

    public static function getInstance()
    {
        return new ResponseTools();
    }

    public function __construct()
    {
        $this->response = [
            'status' => self::RES_SUCCESS
        ];
    }

    public function setStatus($statusMessage)
    {
        $this->response['status'] = $statusMessage;

        return $this;
    }

    public function setMessage($message)
    {
        $this->response['message'] = $message;

        return $this;
    }

    public function setMessageFormat($keyMessage, $replace = [])
    {
        return $this->setMessage(__($keyMessage, $replace));
    }

    public function addMessage($message)
    {
        $this->response['message'][] = $message;

        return $this;
    }

    public function setBody($name, $data)
    {
        $this->response[$name] = $data;

        return $this;
    }
    public function setCount($count)
    {
        return $this->setBody('count', $count);
    }

    public function setData($name, $data, ...$dependencies)
    {
        foreach ($dependencies as $dep) {
            if (isset($dep) == false || $dep == false) {
                return $this;
            }
        }

        return $this->setBody($name, $data);;
    }

    public function getJsonResponse($statusCode = 200)
    {
        return response()->json($this->response, $statusCode);
    }
}