<?php

namespace App\Tools;

use Morilog\Jalali\Jalalian;

class TermTools
{

    /**
     * convert datetime m-d to Y-m-d
     * @template T of array{term:string,started_at:string, ended_at:string}
     * @param T[] $terms
     * @param \Carbon\Carbon|Jalalian|null $date
     * @return T
     */
    public static function getCurrentTerm($terms, $date = null)
    {
        $now = $date === null ? Jalalian::now() : (
            $date instanceof Jalalian ?
            $date :
            Jalalian::fromCarbon($date)
        );

        $currentMonth = $now->getMonth();
        $currentDay = $now->getDay();
        $currentJalaliDateValue = $currentMonth * 100 + $currentDay;

        foreach ($terms as $term) {
            $startedAt = explode('-', $term['started_at']);
            $endedAt = explode('-', $term['ended_at']);

            $startValue = intval($startedAt[0]) * 100 + intval($startedAt[1]);
            $endValue = intval($endedAt[0]) * 100 + intval($endedAt[1]);
            if ($startValue <= $endValue) {
                if (
                    $currentJalaliDateValue >= $startValue &&
                    $currentJalaliDateValue <= $endValue
                ) {
                    return $term;
                }
            } else {
                if (
                    $currentJalaliDateValue >= $startValue ||
                    $currentJalaliDateValue <= $endValue
                ) {
                    return $term;
                }
            }
        }
        return null;
    }

    /**
     * convert term to date carbon
     * @param array{term:string,started_at:string, ended_at:string} $term
     * @param string|int $year
     * @return array{started_at:\Carbon\Carbon, ended_at:\Carbon\Carbon}
     */
    public static function getDateFromTerm($term, $year)
    {
        $startedAtSplit = explode('-', $term['started_at']);
        $endedAtSplit = explode('-', $term['ended_at']);

        $startedAt = new Jalalian(intval($year), intval($startedAtSplit[0]), intval($startedAtSplit[1]));
        $endedAt =  new Jalalian(intval($year), intval($endedAtSplit[0]), intval($endedAtSplit[1]));

        if ($endedAt->lessThan($startedAt)) {
            $endedAt = $endedAt->addYears(1);
        }

        return [
            'started_at' => $startedAt->toCarbon(),
            'ended_at' => $endedAt->toCarbon(),
        ];
    }
}
