<?php

namespace App\Traits;

use ESolution\DBEncryption\Builders\EncryptionEloquentBuilder;
use ESolution\DBEncryption\Encrypter;

trait EncryptedAttribute
{

    public static $enableEncryption = true;

    public static function upsertWithEncryption(array $values, array|string $uniqueBy, array|null $update = null)
    {
        $model = new static;
        $attributeEncryptions = collect($model->getEncryptableAttributes());

        $valuesEncrypted = collect($values)
            ->map(
                fn($el) =>
                $attributeEncryptions->reduce(
                    function ($pv, $keyEncryption) use ($model) {
                        $value = data_get($pv, $keyEncryption);

                        if (array_key_exists($keyEncryption, $model->encryptableCast ?? []) !== false) {
                            $attributes = parent::attributesToArray();
                            $castClass = $model->encryptableCast[$keyEncryption];
                            $value = (new $castClass())->set($model, $keyEncryption, $value, $attributes);
                        }

                        if ($value !== null) {
                            $value = Encrypter::encrypt($value);
                        }

                        data_set($pv, $keyEncryption, $value);

                        return $pv;
                    },
                    $el
                )

            )
            ->toArray();

        return static::upsert($valuesEncrypted, $uniqueBy, $update);
    }

    /**
     * @param $key
     * @return bool
     */
    public function isEncryptable($key)
    {
        if (self::$enableEncryption) {
            return in_array($key, $this->encryptable);
        }
        return false;
    }

    /**
     * @return mixed
     */
    public function getEncryptableAttributes()
    {
        return $this->encryptable;
    }

    public function getAttribute($key)
    {
        $value = parent::getAttribute($key);
        if ($this->isEncryptable($key) && (!is_null($value) && $value != '')) {
            try {
                $value = Encrypter::decrypt($value);

                if (array_key_exists($key, $this->encryptableCast ?? []) !== false) {
                    $attributes = parent::attributesToArray();
                    $castClass = $this->encryptableCast[$key];
                    $value = (new $castClass())->get($this, $key, $value, $attributes);
                }
            } catch (\Exception $th) {
            }
        }
        return $value;
    }

    public function setAttribute($key, $value)
    {
        if ($this->isEncryptable($key)) {
            try {
                if (array_key_exists($key, $this->encryptableCast ?? []) !== false) {
                    $attributes = parent::attributesToArray();
                    $castClass = $this->encryptableCast[$key];
                    $value = (new $castClass())->set($this, $key, $value, $attributes);
                }

                if ($value !== null) {
                    $value = Encrypter::encrypt($value);
                }
            } catch (\Exception $th) {
            }
        }
        return parent::setAttribute($key, $value);
    }

    public function attributesToArray()
    {
        $attributes = parent::attributesToArray();
        if ($attributes) {
            foreach ($attributes as $key => $value) {
                if ($this->isEncryptable($key) && (!is_null($value)) && $value != '') {
                    $attributes[$key] = $value;
                    try {
                        $attributes[$key] = Encrypter::decrypt($value);

                        if (array_key_exists($key, $this->encryptableCast ?? []) !== false) {
                            $castClass = $this->encryptableCast[$key];
                            $attributes[$key] = (new $castClass())->get($this, $key, $attributes[$key], $attributes);
                        }
                    } catch (\Exception $th) {
                    }
                }
            }
        }
        return $attributes;
    }

    // Extend EncryptionEloquentBuilder
    public function newEloquentBuilder($query)
    {
        return new EncryptionEloquentBuilder($query);
    }

    public function decryptAttribute($value)
    {
        return $value ? Encrypter::decrypt($value) : '';
    }

    public function encryptAttribute($value)
    {
        return $value ? Encrypter::encrypt($value) : '';
    }
}
