<?php

namespace App\View\Components;

use Arr;
use Carbon\Carbon;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Morilog\Jalali\Jalalian;

class StudentGradeReport extends Component
{
    public $reportInfo = null;
    public $studentGrades = null;
    public $firstGrade = null;
    public $lastGrade = null;


    /**
     * Create a new component instance.
     */
    public function __construct(
        $reportInfo,
        $studentGrades,
        $firstGrade,
        $lastGrade,
    ) {
        $this->reportInfo = $reportInfo;
        $this->studentGrades = $studentGrades;
        $this->firstGrade = $firstGrade;
        $this->lastGrade = $lastGrade;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.student-grade-report.student-grade-report');
    }

    /**
     * format dataTime to H:i
     * * @param string|null $timeString
     * @return string
     */
    public function formatTime($timeString)
    {
        if (empty($timeString) || $timeString === '-') {
            return '-';
        }

        try {
            return Carbon::parse($timeString)->format('H:i');
        } catch (\Exception $e) {
            return '-';
        }
    }

    public function gradeStartedAt()
    {
        if (
            !isset($this->firstGrade) ||
            !isset($this->firstGrade->created_at)
        ) {
            return '-';
        }

        return Jalalian::fromCarbon($this->firstGrade->created_at)
            ->format('Y/m/d');
    }

    public function gradeEndedAt()
    {
        if (
            !isset($this->lastGrade) ||
            !isset($this->lastGrade->created_at)
        ) {
            return '-';
        }
        return Jalalian::fromCarbon($this->lastGrade->created_at)
            ->format('Y/m/d');
    }

    public function fullName($model)
    {
        return ($model['first_name'] ?? '') . ' ' . ($model['last_name'] ?? '');
    }

    public function teacherFullName($grade)
    {

        if (!isset($grade['teacher']) || !isset($grade['teacher']['profile'])) {
            return '-';
        }

        return $this->fullName($grade['teacher']['profile']);
    }

    public function passingLesson($grade)
    {
        return intval($grade['grade']) >= intval($grade['lesson']['passing_grade']);
    }

    public function finalGrade($grades)
    {
        return number_format(
            array_sum(Arr::pluck($grades, 'grade')) / count($grades),
            2
        );
    }

    public function fatherName($student)
    {
        return data_get($student, 'student_parent.profile.first_name', '-');
    }
}
