<?php

use App\Http\Middleware\JwtPrivateFile;
use App\Http\Middleware\ResetRequest;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->web(prepend: [
            ResetRequest::class
        ]);

        $middleware->api(prepend: [
            ResetRequest::class
        ])
            ->alias([
                'reset-request' => ResetRequest::class,
                'jwt.file' => JwtPrivateFile::class,
            ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
