@include('components.daily-report-presences-and-morals-report.daily-report-presences-and-morals-report-head')

<body>
    <htmlpageheader name="page-header">
        <div>
            <div class="header-title">
                {{ $reportInfo['school_title'] }}
            </div>
            <table class="header-table">
                <tr>
                    <td style="width: 40%; text-align: right;">
                        تاریخ: {{ $date }}
                        <br>
                        کد مدرسه: {{ $reportInfo['school_code'] }}
                    </td>

                    <td style="width: 20%; text-align: center; vertical-align: middle;">
                        <img src="{{ public_path('storage/schools/images/logo.png') }}"
                            class="header-logo"
                            alt="School Logo" />
                    </td>

                    <td style="width: 40%; text-align: left;">
                        نوع: {{ $reportInfo['school_type'] }}
                        <br>
                        استان: {{ $reportInfo['school_province'] }}
                        <br>
                        ناحیه: {{ $reportInfo['school_district'] }}
                    </td>
                </tr>
            </table>
        </div>
    </htmlpageheader>

    <div>
        @foreach ($presences as $bellId => $bellData)
        <?php $bell = $getBell($bellId) ?>
        <table class="bell-table">
            <tr>
                <td>
                    تاخیر و تعجیل
                </td>
                <td>
                    زنگ: {{ $bell->title ?? '-' }}
                </td>

                <td>
                    ساعت شروع: {{ $formatHour($bell?->started_at) }}
                </td>
                <td>
                    ساعت پایان: {{ $formatHour($bell?->ended_at) }}
                </td>
            </tr>
        </table>

        <table class="presences-table">
            <thead>
                <tr>
                    <th class="col-shrink">ردیف</th>
                    <th>نام نام خانوادگی</th>
                    <th>تاخیر</th>
                    <th>تعجیل</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($bellData as $idx => $presence)
                <tr>
                    <td class="col-shrink">{{ $idx+1 }}</td>
                    <td>{{ $fullName($presence['student']) }}</td>
                    <td>{{ $formatHour($presence['entry_time']) }}</td>
                    <td>{{ $formatHour($presence['exit_time']) }}</td>
                </tr>
                @endforeach

            </tbody>
        </table>
        @endforeach

        @foreach ($morals as $bellId => $bellData)
        <?php $bell = $getBell($bellId) ?>
        <table class="bell-table">
            <tr>
                <td>
                    وضعیت اخلاقی
                </td>

                <td>
                    زنگ: {{ $bell->title ?? '-' }}
                </td>

                <td>
                    ساعت شروع: {{ $formatHour($bell?->started_at) }}
                </td>
                <td>
                    ساعت پایان: {{ $formatHour($bell?->ended_at) }}
                </td>
            </tr>
        </table>

        <table class="presences-table">
            <thead>
                <tr>
                    <th class="col-shrink">ردیف</th>
                    <th class="col-shrink">نام نام خانوادگی</th>
                    <th class="col-shrink">وضعیت</th>
                    <th>توضیحات</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($bellData as $idx => $moral)
                <tr>
                    <td class="col-shrink">{{ $idx+1 }}</td>
                    <td class="col-shrink">{{ $fullName($moral['student']) }}</td>
                    <td class="col-shrink">{{ $getMoralStatusString($moral) }}</td>
                    <td>{{ $moral['comment'] ?? '-' }}</td>
                </tr>
                @endforeach

            </tbody>
        </table>
        @endforeach
    </div>
</body>