<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <style>
        @page {
            header: page-header;
            margin-top: 120px;
        }

        .header-table {
            width: 100%;
            margin-bottom: 10px;
            border-collapse: collapse;
        }

        .header-table td {
            border: none;
            padding: 2px 5px;
            font-size: 13px;
            white-space: nowrap;
        }

        .header-logo {
            max-height: 40px;
            width: auto;
            display: inline-block;
        }

        .header-title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            padding: 10px 0;
        }

        .custom-table {
            width: 100%;
            margin: 6px auto;
            border-collapse: collapse;
            font-size: 14px;
        }

        .custom-table th {
            font-weight: 500;
            border: 1px solid #ccc;
            padding: 5px;
            text-align: center;
            vertical-align: middle;
            background-color: #f8f9fa;
        }

        .custom-table td {
            border: 1px solid #ccc;
            padding: 5px;
            text-align: right;
            vertical-align: top;
        }

        .custom-table tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .long-text-column {
            font-size: 0.9em;
        }

        .time-column {
            font-size: 0.8em;
            width: 30px;
            text-align: center;
        }

        .small-column {
            width: 50px;
            text-align: center;
        }
    </style>
</head>


<body>
    <htmlpageheader name="page-header">
        <div>
            <div class="header-title">
                {{ $reportInfo['school_title'] }}
            </div>
            <table class="header-table">
                <tr>
                    <td style="width: 40%; text-align: right;">
                        از تاریخ: {{ $presenceStartedAt() }}
                        <br>
                        تا تاریخ: {{ $presenceEndedAt() }}
                        <br>
                        کد مدرسه: {{ $reportInfo['school_code'] }}
                    </td>

                    <td style="width: 20%; text-align: center; vertical-align: middle;">
                        <img src="{{ public_path('storage/schools/images/logo.png') }}"
                            class="header-logo"
                            alt="School Logo" />
                    </td>

                    <td style="width: 40%; text-align: left;">
                        نوع: {{ $reportInfo['school_type'] }}
                        <br>
                        استان: {{ $reportInfo['school_province'] }}
                        <br>
                        ناحیه: {{ $reportInfo['school_district'] }}
                    </td>
                </tr>
            </table>
        </div>
    </htmlpageheader>

    <table class="custom-table">
        <thead class="thead-dark">
            <tr>
                <th class="small-column">شناسه دانش آموز</th>
                <th>نام نام خانوادگی</th>
                <th class="time-column">ورود</th>
                <th class="time-column">خروج</th>
                <th class="long-text-column">دلیل تاخیر</th>
                <th class="long-text-column">دلیل خروج</th>
            </tr>
        </thead>
        <tbody>
            @forelse($presences as $presence)
            <tr>
                <td class="small-column">{{ $presence->student_id ?? '-' }}</td>
                <td>{{ $presence->student->first_name. ' '.$presence->student->last_name }} </td>

                <td class="time-column">{{ $formatTime($presence->entry_time) ?? '-' }}</td>

                <td class="time-column">{{ $formatTime($presence->exit_time) ?? '-' }}</td>

                <td class="long-text-column">{{ $presence->delay_reason ?? '-' }}</td>

                <td class="long-text-column">{{ $presence->early_exit_reason ?? '-' }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="7" class="text-center text-muted">
                    ❌ هیچ حضوری ثبت نشده است.
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>

</body>